/*
 * 
 */
package w83b.w83bDAO;

import java.util.HashMap;
import java.util.List;

import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;

// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIPreavisosDAO.
 * @author a
 */
public interface W83bIPreavisosDAO {
	
	/**
	 * Buscar preavisos.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarPreavisos (w83b.w83bBeans.W83bPreavisosBean param)throws Exception;
	
	/**
	 * Borrar preaviso.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarPreaviso (java.lang.String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar promotores preaviso original.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarPromotoresPreavisoOriginal (java.lang.String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar promotores.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarPromotores (java.lang.String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar preaviso original.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarPreavisoOriginal (java.lang.String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar docs preaviso.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarDocsPreaviso (java.lang.String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar historial.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarHistorial (java.lang.String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Carga tipos documento.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List cargaTiposDocumento (java.util.HashMap param) throws Exception;
	
	/**
	 * Adjuntar archivo preavisos.
	 * 
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String adjuntarArchivoPreavisos (java.util.HashMap param) throws Exception;
	
	/**
	 * Anyadir preavisos.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public HashMap anyadirPreavisos (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;
	
	/**
	 * Insertar docs preavisos.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public String insertarDocsPreavisos (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;
	
	/**
	 * Insertar preaviso original.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void insertarPreavisoOriginal (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;
	
	/**
	 * Anyadir promotores.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void anyadirPromotores (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;
	
	/**
	 * Anyadir promotores original.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void anyadirPromotoresOriginal (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;
	
	/**
	 * Descargar documento.
	 * 
	 * @param param the param
	 * @return the w83b.w83b beans. w83b doc bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bDocBean descargarDocumento (java.lang.String param) throws Exception;
	
	/**
	 * Anyadir historial tramitacion.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void anyadirHistorialTramitacion (w83b.w83bBeans.W83bPreavisosBean  param,String fase, String tramite,String fechaRegistro) throws Exception;
	
	/**
	 * Borrar docs preavisos.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void borrarDocsPreavisos (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;

	
	
	
	/**
	 * Obtener datos basicos preaviso.
	 * 
	 * @param param the param
	 * @return the w83b preavisos bean
	 * @throws Exception the exception
	 */
	public W83bPreavisosBean obtenerDatosBasicosPreaviso (java.lang.String param,String idioma) throws Exception;

	/**
	 * Obtener preaviso original.
	 *
	 * @param param the param
	 * @param idioma the idioma
	 * @return the w83b preavisos bean
	 * @throws Exception the exception
	 */
	public W83bPreavisosBean obtenerPreavisoOriginal (java.lang.String param,String idioma) throws Exception;
	
	/**
	 * Obtener docs preaviso.
	 * 
	 * @param param the param
	 * @return the w83b preavisos bean
	 * @throws Exception the exception
	 */
	public W83bPreavisosBean obtenerDocsPreaviso (java.lang.String param,String idioma) throws Exception;
	
	/**
	 * Obtener impugnaciones preaviso.
	 *
	 * @param param the param
	 * @param columnaOrder the columna order
	 * @param tipoOrdenacion the tipo ordenacion
	 * @return the w83b preavisos bean
	 * @throws Exception the exception
	 */
	public W83bPreavisosBean obtenerImpugnacionesPreaviso (java.lang.String param,String columnaOrder,String tipoOrdenacion,String idioma) throws Exception;
	
	/**
	 * Obtener historial preaviso.
	 *
	 * @param param the param
	 * @param columnaOrder the columna order
	 * @param tipoOrdenacion the tipo ordenacion
	 * @return the w83b preavisos bean
	 * @throws Exception the exception
	 */
	public W83bPreavisosBean obtenerHistorialPreaviso (java.lang.String param,String columnaOrder,String tipoOrdenacion,String strIdioma) throws Exception;
	
	/**
	 * Obtener tramites preaviso.
	 *
	 * @param param the param
	 * @param idioma the idioma
	 * @param columnaOrder the columna order
	 * @param tipoOrdenacion the tipo ordenacion
	 * @return the w83b preavisos bean
	 * @throws Exception the exception
	 */
	public W83bPreavisosBean obtenerTramitesPreaviso (java.lang.String param,String idioma,String columnaOrder,String tipoOrdenacion,String strIdioma) throws Exception;
	
	/**
	 * Editar preavisos.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void editarPreavisos (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;
	
	/**
	 * Editar preavisos original.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void editarPreavisosOriginal (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;

	/**
	 * Borrar promotores preavisos.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void borrarPromotoresPreavisos (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;
	
	/**
	 * Borrar promotores preavisos original.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void borrarPromotoresPreavisosOriginal (w83b.w83bBeans.W83bPreavisosBean  param) throws Exception;
	
	/**
	 * Max cod preavisos.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxCodPreavisos(W83bPreavisosBean param)throws Exception;
	
	/**
	 * Contar preavisos.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarPreavisos(W83bPreavisosBean param)throws Exception;
	
	/**
	 * Existe preaviso.
	 *
	 * @param param the param
	 * @param numPreaviso the num preaviso
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existePreaviso(W83bPreavisosBean param,String numPreaviso) throws Exception;
	
	/**
	 * Insertar historial tramitacion.
	 *
	 * @param codSelec the cod selec
	 * @param user the user
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarHistorialTramitacion(String codSelec,String user)throws Exception;
	
	/**
	 * Existe centro preaviso.
	 *
	 * @param idCentroTrabajo the id centro trabajo
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeCentroPreaviso(String idCentroTrabajo,String territorioPreaviso,String anyoPreaviso,String nPreaviso) throws Exception;
	
	/**
	 * Borrar historial tramitacion preaviso.
	 *
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarHistorialTramitacionPreaviso(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;

	/**
	 * Detalle preaviso.
	 *
	 * @param param the param
	 * @return the w83b preavisos bean
	 * @throws Exception the exception
	 */
	public W83bPreavisosBean detallePreaviso(W83bPreavisosBean param) throws Exception;
	
	/**
	 * Existe preaviso impug.
	 *
	 * @param param the param
	 * @param numPreaviso the num preaviso
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existePreavisoImpug(W83bPreavisosBean param,String numPreaviso) throws Exception;
	
	/**
	 * Detalle preaviso impug.
	 *
	 * @param param the param
	 * @return the w83b preavisos bean
	 * @throws Exception the exception
	 */
	public W83bPreavisosBean detallePreavisoImpug(W83bPreavisosBean param) throws Exception;

	public boolean existeOtroCentroPreavisoSinFechaEleccion(String idCentroTrabajo,String territorioPreaviso, String anyoPreaviso,String numPreaviso) throws Exception;
	
	public List validarIntervaloEleccionSindicalCtoTrabajo(String idCentroTrabajo,String idioma,String territorioPreaviso, String anyoPreaviso,String numPreaviso) throws Exception;
	
	public List buscarImpugnacion(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	public W83bPreavisosBean obtenerRegDefinitivoActaPreaviso(W83bPreavisosBean preaviso)throws Exception;
	
	public void editarTramite(W83bPreavisosBean param, int fase, int tramite) throws Exception;
	
	public boolean existeTramite(W83bPreavisosBean param,int fase, int tramite)throws Exception;
	
	public HashMap calcularNumPreaviso(W83bPreavisosBean param)throws Exception;
	
	/**
    * Actualiza la informacin de acuse de recibo de una comunicacin de un preaviso
    * @param listaComunicacionesAcuse List
    * @throws Exception the exception
    */
	public void  actualizarDatosAcuseComunicacion(W83bDocBean docBean) throws Exception;
}
